// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.KeyVault.Models
{
    /// <summary> The private endpoint connection status. </summary>
    public readonly partial struct KeyVaultPrivateEndpointServiceConnectionStatus : IEquatable<KeyVaultPrivateEndpointServiceConnectionStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="KeyVaultPrivateEndpointServiceConnectionStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public KeyVaultPrivateEndpointServiceConnectionStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PendingValue = "Pending";
        private const string ApprovedValue = "Approved";
        private const string RejectedValue = "Rejected";
        private const string DisconnectedValue = "Disconnected";

        /// <summary> Pending. </summary>
        public static KeyVaultPrivateEndpointServiceConnectionStatus Pending { get; } = new KeyVaultPrivateEndpointServiceConnectionStatus(PendingValue);
        /// <summary> Approved. </summary>
        public static KeyVaultPrivateEndpointServiceConnectionStatus Approved { get; } = new KeyVaultPrivateEndpointServiceConnectionStatus(ApprovedValue);
        /// <summary> Rejected. </summary>
        public static KeyVaultPrivateEndpointServiceConnectionStatus Rejected { get; } = new KeyVaultPrivateEndpointServiceConnectionStatus(RejectedValue);
        /// <summary> Disconnected. </summary>
        public static KeyVaultPrivateEndpointServiceConnectionStatus Disconnected { get; } = new KeyVaultPrivateEndpointServiceConnectionStatus(DisconnectedValue);
        /// <summary> Determines if two <see cref="KeyVaultPrivateEndpointServiceConnectionStatus"/> values are the same. </summary>
        public static bool operator ==(KeyVaultPrivateEndpointServiceConnectionStatus left, KeyVaultPrivateEndpointServiceConnectionStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="KeyVaultPrivateEndpointServiceConnectionStatus"/> values are not the same. </summary>
        public static bool operator !=(KeyVaultPrivateEndpointServiceConnectionStatus left, KeyVaultPrivateEndpointServiceConnectionStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="KeyVaultPrivateEndpointServiceConnectionStatus"/>. </summary>
        public static implicit operator KeyVaultPrivateEndpointServiceConnectionStatus(string value) => new KeyVaultPrivateEndpointServiceConnectionStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is KeyVaultPrivateEndpointServiceConnectionStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(KeyVaultPrivateEndpointServiceConnectionStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
