// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.KeyVault.Models
{
    /// <summary> The IdentityAccessSecretPermission. </summary>
    public readonly partial struct IdentityAccessSecretPermission : IEquatable<IdentityAccessSecretPermission>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IdentityAccessSecretPermission"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IdentityAccessSecretPermission(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AllValue = "all";
        private const string GetValue = "get";
        private const string ListValue = "list";
        private const string SetValue = "set";
        private const string DeleteValue = "delete";
        private const string BackupValue = "backup";
        private const string RestoreValue = "restore";
        private const string RecoverValue = "recover";
        private const string PurgeValue = "purge";

        /// <summary> all. </summary>
        public static IdentityAccessSecretPermission All { get; } = new IdentityAccessSecretPermission(AllValue);
        /// <summary> get. </summary>
        public static IdentityAccessSecretPermission Get { get; } = new IdentityAccessSecretPermission(GetValue);
        /// <summary> list. </summary>
        public static IdentityAccessSecretPermission List { get; } = new IdentityAccessSecretPermission(ListValue);
        /// <summary> set. </summary>
        public static IdentityAccessSecretPermission Set { get; } = new IdentityAccessSecretPermission(SetValue);
        /// <summary> delete. </summary>
        public static IdentityAccessSecretPermission Delete { get; } = new IdentityAccessSecretPermission(DeleteValue);
        /// <summary> backup. </summary>
        public static IdentityAccessSecretPermission Backup { get; } = new IdentityAccessSecretPermission(BackupValue);
        /// <summary> restore. </summary>
        public static IdentityAccessSecretPermission Restore { get; } = new IdentityAccessSecretPermission(RestoreValue);
        /// <summary> recover. </summary>
        public static IdentityAccessSecretPermission Recover { get; } = new IdentityAccessSecretPermission(RecoverValue);
        /// <summary> purge. </summary>
        public static IdentityAccessSecretPermission Purge { get; } = new IdentityAccessSecretPermission(PurgeValue);
        /// <summary> Determines if two <see cref="IdentityAccessSecretPermission"/> values are the same. </summary>
        public static bool operator ==(IdentityAccessSecretPermission left, IdentityAccessSecretPermission right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IdentityAccessSecretPermission"/> values are not the same. </summary>
        public static bool operator !=(IdentityAccessSecretPermission left, IdentityAccessSecretPermission right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IdentityAccessSecretPermission"/>. </summary>
        public static implicit operator IdentityAccessSecretPermission(string value) => new IdentityAccessSecretPermission(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IdentityAccessSecretPermission other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IdentityAccessSecretPermission other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
