// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.KeyVault.Models
{
    /// <summary> The IdentityAccessKeyPermission. </summary>
    public readonly partial struct IdentityAccessKeyPermission : IEquatable<IdentityAccessKeyPermission>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IdentityAccessKeyPermission"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IdentityAccessKeyPermission(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AllValue = "all";
        private const string EncryptValue = "encrypt";
        private const string DecryptValue = "decrypt";
        private const string WrapKeyValue = "wrapKey";
        private const string UnwrapKeyValue = "unwrapKey";
        private const string SignValue = "sign";
        private const string VerifyValue = "verify";
        private const string GetValue = "get";
        private const string ListValue = "list";
        private const string CreateValue = "create";
        private const string UpdateValue = "update";
        private const string ImportValue = "import";
        private const string DeleteValue = "delete";
        private const string BackupValue = "backup";
        private const string RestoreValue = "restore";
        private const string RecoverValue = "recover";
        private const string PurgeValue = "purge";
        private const string ReleaseValue = "release";
        private const string RotateValue = "rotate";
        private const string GetrotationpolicyValue = "getrotationpolicy";
        private const string SetrotationpolicyValue = "setrotationpolicy";

        /// <summary> all. </summary>
        public static IdentityAccessKeyPermission All { get; } = new IdentityAccessKeyPermission(AllValue);
        /// <summary> encrypt. </summary>
        public static IdentityAccessKeyPermission Encrypt { get; } = new IdentityAccessKeyPermission(EncryptValue);
        /// <summary> decrypt. </summary>
        public static IdentityAccessKeyPermission Decrypt { get; } = new IdentityAccessKeyPermission(DecryptValue);
        /// <summary> wrapKey. </summary>
        public static IdentityAccessKeyPermission WrapKey { get; } = new IdentityAccessKeyPermission(WrapKeyValue);
        /// <summary> unwrapKey. </summary>
        public static IdentityAccessKeyPermission UnwrapKey { get; } = new IdentityAccessKeyPermission(UnwrapKeyValue);
        /// <summary> sign. </summary>
        public static IdentityAccessKeyPermission Sign { get; } = new IdentityAccessKeyPermission(SignValue);
        /// <summary> verify. </summary>
        public static IdentityAccessKeyPermission Verify { get; } = new IdentityAccessKeyPermission(VerifyValue);
        /// <summary> get. </summary>
        public static IdentityAccessKeyPermission Get { get; } = new IdentityAccessKeyPermission(GetValue);
        /// <summary> list. </summary>
        public static IdentityAccessKeyPermission List { get; } = new IdentityAccessKeyPermission(ListValue);
        /// <summary> create. </summary>
        public static IdentityAccessKeyPermission Create { get; } = new IdentityAccessKeyPermission(CreateValue);
        /// <summary> update. </summary>
        public static IdentityAccessKeyPermission Update { get; } = new IdentityAccessKeyPermission(UpdateValue);
        /// <summary> import. </summary>
        public static IdentityAccessKeyPermission Import { get; } = new IdentityAccessKeyPermission(ImportValue);
        /// <summary> delete. </summary>
        public static IdentityAccessKeyPermission Delete { get; } = new IdentityAccessKeyPermission(DeleteValue);
        /// <summary> backup. </summary>
        public static IdentityAccessKeyPermission Backup { get; } = new IdentityAccessKeyPermission(BackupValue);
        /// <summary> restore. </summary>
        public static IdentityAccessKeyPermission Restore { get; } = new IdentityAccessKeyPermission(RestoreValue);
        /// <summary> recover. </summary>
        public static IdentityAccessKeyPermission Recover { get; } = new IdentityAccessKeyPermission(RecoverValue);
        /// <summary> purge. </summary>
        public static IdentityAccessKeyPermission Purge { get; } = new IdentityAccessKeyPermission(PurgeValue);
        /// <summary> release. </summary>
        public static IdentityAccessKeyPermission Release { get; } = new IdentityAccessKeyPermission(ReleaseValue);
        /// <summary> rotate. </summary>
        public static IdentityAccessKeyPermission Rotate { get; } = new IdentityAccessKeyPermission(RotateValue);
        /// <summary> getrotationpolicy. </summary>
        public static IdentityAccessKeyPermission Getrotationpolicy { get; } = new IdentityAccessKeyPermission(GetrotationpolicyValue);
        /// <summary> setrotationpolicy. </summary>
        public static IdentityAccessKeyPermission Setrotationpolicy { get; } = new IdentityAccessKeyPermission(SetrotationpolicyValue);
        /// <summary> Determines if two <see cref="IdentityAccessKeyPermission"/> values are the same. </summary>
        public static bool operator ==(IdentityAccessKeyPermission left, IdentityAccessKeyPermission right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IdentityAccessKeyPermission"/> values are not the same. </summary>
        public static bool operator !=(IdentityAccessKeyPermission left, IdentityAccessKeyPermission right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IdentityAccessKeyPermission"/>. </summary>
        public static implicit operator IdentityAccessKeyPermission(string value) => new IdentityAccessKeyPermission(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IdentityAccessKeyPermission other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IdentityAccessKeyPermission other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
