// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.KeyVault
{
    internal class ManagedHsmPrivateEndpointConnectionOperationSource : IOperationSource<ManagedHsmPrivateEndpointConnectionResource>
    {
        private readonly ArmClient _client;

        internal ManagedHsmPrivateEndpointConnectionOperationSource(ArmClient client)
        {
            _client = client;
        }

        ManagedHsmPrivateEndpointConnectionResource IOperationSource<ManagedHsmPrivateEndpointConnectionResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ManagedHsmPrivateEndpointConnectionData.DeserializeManagedHsmPrivateEndpointConnectionData(document.RootElement);
            return new ManagedHsmPrivateEndpointConnectionResource(_client, data);
        }

        async ValueTask<ManagedHsmPrivateEndpointConnectionResource> IOperationSource<ManagedHsmPrivateEndpointConnectionResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ManagedHsmPrivateEndpointConnectionData.DeserializeManagedHsmPrivateEndpointConnectionData(document.RootElement);
            return new ManagedHsmPrivateEndpointConnectionResource(_client, data);
        }
    }
}
