// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.KeyVault
{
    internal class KeyVaultOperationSource : IOperationSource<KeyVaultResource>
    {
        private readonly ArmClient _client;

        internal KeyVaultOperationSource(ArmClient client)
        {
            _client = client;
        }

        KeyVaultResource IOperationSource<KeyVaultResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = KeyVaultData.DeserializeKeyVaultData(document.RootElement);
            return new KeyVaultResource(_client, data);
        }

        async ValueTask<KeyVaultResource> IOperationSource<KeyVaultResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = KeyVaultData.DeserializeKeyVaultData(document.RootElement);
            return new KeyVaultResource(_client, data);
        }
    }
}
