// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.KeyVault.Models;

namespace Azure.ResourceManager.KeyVault.Samples
{
    public partial class Sample_KeyVaultSecretCollection
    {
        // Create a secret
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateASecret()
        {
            // Generated from example definition: specification/keyvault/resource-manager/Microsoft.KeyVault/stable/2023-07-01/examples/createSecret.json
            // this example is just showing the usage of "Secrets_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this KeyVaultResource created on azure
            // for more information of creating KeyVaultResource, please refer to the document of KeyVaultResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "sample-group";
            string vaultName = "sample-vault";
            ResourceIdentifier keyVaultResourceId = KeyVaultResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, vaultName);
            KeyVaultResource keyVault = client.GetKeyVaultResource(keyVaultResourceId);

            // get the collection of this KeyVaultSecretResource
            KeyVaultSecretCollection collection = keyVault.GetKeyVaultSecrets();

            // invoke the operation
            string secretName = "secret-name";
            KeyVaultSecretCreateOrUpdateContent content = new KeyVaultSecretCreateOrUpdateContent(new SecretProperties()
            {
                Value = "secret-value",
            });
            ArmOperation<KeyVaultSecretResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, secretName, content);
            KeyVaultSecretResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            KeyVaultSecretData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get a secret
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetASecret()
        {
            // Generated from example definition: specification/keyvault/resource-manager/Microsoft.KeyVault/stable/2023-07-01/examples/getSecret.json
            // this example is just showing the usage of "Secrets_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this KeyVaultResource created on azure
            // for more information of creating KeyVaultResource, please refer to the document of KeyVaultResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "sample-group";
            string vaultName = "sample-vault";
            ResourceIdentifier keyVaultResourceId = KeyVaultResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, vaultName);
            KeyVaultResource keyVault = client.GetKeyVaultResource(keyVaultResourceId);

            // get the collection of this KeyVaultSecretResource
            KeyVaultSecretCollection collection = keyVault.GetKeyVaultSecrets();

            // invoke the operation
            string secretName = "secret-name";
            KeyVaultSecretResource result = await collection.GetAsync(secretName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            KeyVaultSecretData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get a secret
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetASecret()
        {
            // Generated from example definition: specification/keyvault/resource-manager/Microsoft.KeyVault/stable/2023-07-01/examples/getSecret.json
            // this example is just showing the usage of "Secrets_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this KeyVaultResource created on azure
            // for more information of creating KeyVaultResource, please refer to the document of KeyVaultResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "sample-group";
            string vaultName = "sample-vault";
            ResourceIdentifier keyVaultResourceId = KeyVaultResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, vaultName);
            KeyVaultResource keyVault = client.GetKeyVaultResource(keyVaultResourceId);

            // get the collection of this KeyVaultSecretResource
            KeyVaultSecretCollection collection = keyVault.GetKeyVaultSecrets();

            // invoke the operation
            string secretName = "secret-name";
            bool result = await collection.ExistsAsync(secretName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get a secret
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetASecret()
        {
            // Generated from example definition: specification/keyvault/resource-manager/Microsoft.KeyVault/stable/2023-07-01/examples/getSecret.json
            // this example is just showing the usage of "Secrets_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this KeyVaultResource created on azure
            // for more information of creating KeyVaultResource, please refer to the document of KeyVaultResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "sample-group";
            string vaultName = "sample-vault";
            ResourceIdentifier keyVaultResourceId = KeyVaultResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, vaultName);
            KeyVaultResource keyVault = client.GetKeyVaultResource(keyVaultResourceId);

            // get the collection of this KeyVaultSecretResource
            KeyVaultSecretCollection collection = keyVault.GetKeyVaultSecrets();

            // invoke the operation
            string secretName = "secret-name";
            NullableResponse<KeyVaultSecretResource> response = await collection.GetIfExistsAsync(secretName);
            KeyVaultSecretResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                KeyVaultSecretData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // List secrets in the vault
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListSecretsInTheVault()
        {
            // Generated from example definition: specification/keyvault/resource-manager/Microsoft.KeyVault/stable/2023-07-01/examples/listSecrets.json
            // this example is just showing the usage of "Secrets_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this KeyVaultResource created on azure
            // for more information of creating KeyVaultResource, please refer to the document of KeyVaultResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "sample-group";
            string vaultName = "sample-vault";
            ResourceIdentifier keyVaultResourceId = KeyVaultResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, vaultName);
            KeyVaultResource keyVault = client.GetKeyVaultResource(keyVaultResourceId);

            // get the collection of this KeyVaultSecretResource
            KeyVaultSecretCollection collection = keyVault.GetKeyVaultSecrets();

            // invoke the operation and iterate over the result
            await foreach (KeyVaultSecretResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                KeyVaultSecretData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
