// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.IotHub.Models
{
    /// <summary> The properties related to the custom endpoints to which your IoT hub routes messages based on the routing rules. A maximum of 10 custom endpoints are allowed across all endpoint types for paid hubs and only 1 custom endpoint is allowed across all endpoint types for free hubs. </summary>
    public partial class RoutingEndpoints
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RoutingEndpoints"/>. </summary>
        public RoutingEndpoints()
        {
            ServiceBusQueues = new ChangeTrackingList<RoutingServiceBusQueueEndpointProperties>();
            ServiceBusTopics = new ChangeTrackingList<RoutingServiceBusTopicEndpointProperties>();
            EventHubs = new ChangeTrackingList<RoutingEventHubProperties>();
            StorageContainers = new ChangeTrackingList<RoutingStorageContainerProperties>();
            CosmosDBSqlContainers = new ChangeTrackingList<RoutingCosmosDBSqlApiProperties>();
        }

        /// <summary> Initializes a new instance of <see cref="RoutingEndpoints"/>. </summary>
        /// <param name="serviceBusQueues"> The list of Service Bus queue endpoints that IoT hub routes the messages to, based on the routing rules. </param>
        /// <param name="serviceBusTopics"> The list of Service Bus topic endpoints that the IoT hub routes the messages to, based on the routing rules. </param>
        /// <param name="eventHubs"> The list of Event Hubs endpoints that IoT hub routes messages to, based on the routing rules. This list does not include the built-in Event Hubs endpoint. </param>
        /// <param name="storageContainers"> The list of storage container endpoints that IoT hub routes messages to, based on the routing rules. </param>
        /// <param name="cosmosDBSqlContainers"> The list of Cosmos DB container endpoints that IoT hub routes messages to, based on the routing rules. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RoutingEndpoints(IList<RoutingServiceBusQueueEndpointProperties> serviceBusQueues, IList<RoutingServiceBusTopicEndpointProperties> serviceBusTopics, IList<RoutingEventHubProperties> eventHubs, IList<RoutingStorageContainerProperties> storageContainers, IList<RoutingCosmosDBSqlApiProperties> cosmosDBSqlContainers, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ServiceBusQueues = serviceBusQueues;
            ServiceBusTopics = serviceBusTopics;
            EventHubs = eventHubs;
            StorageContainers = storageContainers;
            CosmosDBSqlContainers = cosmosDBSqlContainers;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The list of Service Bus queue endpoints that IoT hub routes the messages to, based on the routing rules. </summary>
        public IList<RoutingServiceBusQueueEndpointProperties> ServiceBusQueues { get; }
        /// <summary> The list of Service Bus topic endpoints that the IoT hub routes the messages to, based on the routing rules. </summary>
        public IList<RoutingServiceBusTopicEndpointProperties> ServiceBusTopics { get; }
        /// <summary> The list of Event Hubs endpoints that IoT hub routes messages to, based on the routing rules. This list does not include the built-in Event Hubs endpoint. </summary>
        public IList<RoutingEventHubProperties> EventHubs { get; }
        /// <summary> The list of storage container endpoints that IoT hub routes messages to, based on the routing rules. </summary>
        public IList<RoutingStorageContainerProperties> StorageContainers { get; }
        /// <summary> The list of Cosmos DB container endpoints that IoT hub routes messages to, based on the routing rules. </summary>
        public IList<RoutingCosmosDBSqlApiProperties> CosmosDBSqlContainers { get; }
    }
}
