// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.IotHub.Models
{
    /// <summary> Compilation error when evaluating route. </summary>
    public partial class RouteCompilationError
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RouteCompilationError"/>. </summary>
        internal RouteCompilationError()
        {
        }

        /// <summary> Initializes a new instance of <see cref="RouteCompilationError"/>. </summary>
        /// <param name="message"> Route error message. </param>
        /// <param name="severity"> Severity of the route error. </param>
        /// <param name="location"> Location where the route error happened. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RouteCompilationError(string message, RouteErrorSeverity? severity, RouteErrorRange location, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Message = message;
            Severity = severity;
            Location = location;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Route error message. </summary>
        public string Message { get; }
        /// <summary> Severity of the route error. </summary>
        public RouteErrorSeverity? Severity { get; }
        /// <summary> Location where the route error happened. </summary>
        public RouteErrorRange Location { get; }
    }
}
