// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.IotHub.Models
{
    /// <summary> Result of testing one route. </summary>
    public partial class IotHubTestRouteResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="IotHubTestRouteResult"/>. </summary>
        internal IotHubTestRouteResult()
        {
        }

        /// <summary> Initializes a new instance of <see cref="IotHubTestRouteResult"/>. </summary>
        /// <param name="result"> Result of testing route. </param>
        /// <param name="details"> Detailed result of testing route. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal IotHubTestRouteResult(IotHubTestResultStatus? result, IotHubTestRouteResultDetails details, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Result = result;
            Details = details;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Result of testing route. </summary>
        public IotHubTestResultStatus? Result { get; }
        /// <summary> Detailed result of testing route. </summary>
        internal IotHubTestRouteResultDetails Details { get; }
        /// <summary> JSON-serialized list of route compilation errors. </summary>
        public IReadOnlyList<RouteCompilationError> DetailsCompilationErrors
        {
            get => Details?.CompilationErrors;
        }
    }
}
