// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.IotHub.Models
{
    /// <summary> The properties of the Azure Storage endpoint for file upload. </summary>
    public partial class IotHubStorageEndpointProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="IotHubStorageEndpointProperties"/>. </summary>
        /// <param name="connectionString"> The connection string for the Azure Storage account to which files are uploaded. </param>
        /// <param name="containerName"> The name of the root container where you upload files. The container need not exist but should be creatable using the connectionString specified. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="connectionString"/> or <paramref name="containerName"/> is null. </exception>
        public IotHubStorageEndpointProperties(string connectionString, string containerName)
        {
            Argument.AssertNotNull(connectionString, nameof(connectionString));
            Argument.AssertNotNull(containerName, nameof(containerName));

            ConnectionString = connectionString;
            ContainerName = containerName;
        }

        /// <summary> Initializes a new instance of <see cref="IotHubStorageEndpointProperties"/>. </summary>
        /// <param name="sasTtlAsIso8601"> The period of time for which the SAS URI generated by IoT Hub for file upload is valid. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload#file-upload-notification-configuration-options. </param>
        /// <param name="connectionString"> The connection string for the Azure Storage account to which files are uploaded. </param>
        /// <param name="containerName"> The name of the root container where you upload files. The container need not exist but should be creatable using the connectionString specified. </param>
        /// <param name="authenticationType"> Specifies authentication type being used for connecting to the storage account. </param>
        /// <param name="identity"> Managed identity properties of storage endpoint for file upload. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal IotHubStorageEndpointProperties(TimeSpan? sasTtlAsIso8601, string connectionString, string containerName, IotHubAuthenticationType? authenticationType, ManagedIdentity identity, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SasTtlAsIso8601 = sasTtlAsIso8601;
            ConnectionString = connectionString;
            ContainerName = containerName;
            AuthenticationType = authenticationType;
            Identity = identity;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="IotHubStorageEndpointProperties"/> for deserialization. </summary>
        internal IotHubStorageEndpointProperties()
        {
        }

        /// <summary> The period of time for which the SAS URI generated by IoT Hub for file upload is valid. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload#file-upload-notification-configuration-options. </summary>
        public TimeSpan? SasTtlAsIso8601 { get; set; }
        /// <summary> The connection string for the Azure Storage account to which files are uploaded. </summary>
        public string ConnectionString { get; set; }
        /// <summary> The name of the root container where you upload files. The container need not exist but should be creatable using the connectionString specified. </summary>
        public string ContainerName { get; set; }
        /// <summary> Specifies authentication type being used for connecting to the storage account. </summary>
        public IotHubAuthenticationType? AuthenticationType { get; set; }
        /// <summary> Managed identity properties of storage endpoint for file upload. </summary>
        internal ManagedIdentity Identity { get; set; }
        /// <summary> The user assigned identity. </summary>
        public ResourceIdentifier UserAssignedIdentity
        {
            get => Identity is null ? default : Identity.UserAssignedIdentity;
            set
            {
                if (Identity is null)
                    Identity = new ManagedIdentity();
                Identity.UserAssignedIdentity = value;
            }
        }
    }
}
