// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.IotHub.Models
{
    internal static partial class IotHubSharedAccessRightExtensions
    {
        public static string ToSerialString(this IotHubSharedAccessRight value) => value switch
        {
            IotHubSharedAccessRight.RegistryRead => "RegistryRead",
            IotHubSharedAccessRight.RegistryWrite => "RegistryWrite",
            IotHubSharedAccessRight.ServiceConnect => "ServiceConnect",
            IotHubSharedAccessRight.DeviceConnect => "DeviceConnect",
            IotHubSharedAccessRight.RegistryReadRegistryWrite => "RegistryRead, RegistryWrite",
            IotHubSharedAccessRight.RegistryReadServiceConnect => "RegistryRead, ServiceConnect",
            IotHubSharedAccessRight.RegistryReadDeviceConnect => "RegistryRead, DeviceConnect",
            IotHubSharedAccessRight.RegistryWriteServiceConnect => "RegistryWrite, ServiceConnect",
            IotHubSharedAccessRight.RegistryWriteDeviceConnect => "RegistryWrite, DeviceConnect",
            IotHubSharedAccessRight.ServiceConnectDeviceConnect => "ServiceConnect, DeviceConnect",
            IotHubSharedAccessRight.RegistryReadRegistryWriteServiceConnect => "RegistryRead, RegistryWrite, ServiceConnect",
            IotHubSharedAccessRight.RegistryReadRegistryWriteDeviceConnect => "RegistryRead, RegistryWrite, DeviceConnect",
            IotHubSharedAccessRight.RegistryReadServiceConnectDeviceConnect => "RegistryRead, ServiceConnect, DeviceConnect",
            IotHubSharedAccessRight.RegistryWriteServiceConnectDeviceConnect => "RegistryWrite, ServiceConnect, DeviceConnect",
            IotHubSharedAccessRight.RegistryReadRegistryWriteServiceConnectDeviceConnect => "RegistryRead, RegistryWrite, ServiceConnect, DeviceConnect",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown IotHubSharedAccessRight value.")
        };

        public static IotHubSharedAccessRight ToIotHubSharedAccessRight(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "RegistryRead")) return IotHubSharedAccessRight.RegistryRead;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "RegistryWrite")) return IotHubSharedAccessRight.RegistryWrite;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "ServiceConnect")) return IotHubSharedAccessRight.ServiceConnect;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "DeviceConnect")) return IotHubSharedAccessRight.DeviceConnect;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "RegistryRead, RegistryWrite")) return IotHubSharedAccessRight.RegistryReadRegistryWrite;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "RegistryRead, ServiceConnect")) return IotHubSharedAccessRight.RegistryReadServiceConnect;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "RegistryRead, DeviceConnect")) return IotHubSharedAccessRight.RegistryReadDeviceConnect;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "RegistryWrite, ServiceConnect")) return IotHubSharedAccessRight.RegistryWriteServiceConnect;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "RegistryWrite, DeviceConnect")) return IotHubSharedAccessRight.RegistryWriteDeviceConnect;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "ServiceConnect, DeviceConnect")) return IotHubSharedAccessRight.ServiceConnectDeviceConnect;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "RegistryRead, RegistryWrite, ServiceConnect")) return IotHubSharedAccessRight.RegistryReadRegistryWriteServiceConnect;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "RegistryRead, RegistryWrite, DeviceConnect")) return IotHubSharedAccessRight.RegistryReadRegistryWriteDeviceConnect;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "RegistryRead, ServiceConnect, DeviceConnect")) return IotHubSharedAccessRight.RegistryReadServiceConnectDeviceConnect;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "RegistryWrite, ServiceConnect, DeviceConnect")) return IotHubSharedAccessRight.RegistryWriteServiceConnectDeviceConnect;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "RegistryRead, RegistryWrite, ServiceConnect, DeviceConnect")) return IotHubSharedAccessRight.RegistryReadRegistryWriteServiceConnectDeviceConnect;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown IotHubSharedAccessRight value.");
        }
    }
}
