// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.IotHub.Models
{
    internal static partial class IotHubScaleTypeExtensions
    {
        public static string ToSerialString(this IotHubScaleType value) => value switch
        {
            IotHubScaleType.None => "None",
            IotHubScaleType.Automatic => "Automatic",
            IotHubScaleType.Manual => "Manual",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown IotHubScaleType value.")
        };

        public static IotHubScaleType ToIotHubScaleType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "None")) return IotHubScaleType.None;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Automatic")) return IotHubScaleType.Automatic;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Manual")) return IotHubScaleType.Manual;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown IotHubScaleType value.");
        }
    }
}
