// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.IotHub.Models
{
    /// <summary> The source that the routing rule is to be applied to, such as DeviceMessages. </summary>
    public readonly partial struct IotHubRoutingSource : IEquatable<IotHubRoutingSource>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IotHubRoutingSource"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IotHubRoutingSource(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string DeviceMessagesValue = "DeviceMessages";
        private const string TwinChangeEventsValue = "TwinChangeEvents";
        private const string DeviceLifecycleEventsValue = "DeviceLifecycleEvents";
        private const string DeviceJobLifecycleEventsValue = "DeviceJobLifecycleEvents";
        private const string DeviceConnectionStateEventsValue = "DeviceConnectionStateEvents";

        /// <summary> Invalid. </summary>
        public static IotHubRoutingSource Invalid { get; } = new IotHubRoutingSource(InvalidValue);
        /// <summary> DeviceMessages. </summary>
        public static IotHubRoutingSource DeviceMessages { get; } = new IotHubRoutingSource(DeviceMessagesValue);
        /// <summary> TwinChangeEvents. </summary>
        public static IotHubRoutingSource TwinChangeEvents { get; } = new IotHubRoutingSource(TwinChangeEventsValue);
        /// <summary> DeviceLifecycleEvents. </summary>
        public static IotHubRoutingSource DeviceLifecycleEvents { get; } = new IotHubRoutingSource(DeviceLifecycleEventsValue);
        /// <summary> DeviceJobLifecycleEvents. </summary>
        public static IotHubRoutingSource DeviceJobLifecycleEvents { get; } = new IotHubRoutingSource(DeviceJobLifecycleEventsValue);
        /// <summary> DeviceConnectionStateEvents. </summary>
        public static IotHubRoutingSource DeviceConnectionStateEvents { get; } = new IotHubRoutingSource(DeviceConnectionStateEventsValue);
        /// <summary> Determines if two <see cref="IotHubRoutingSource"/> values are the same. </summary>
        public static bool operator ==(IotHubRoutingSource left, IotHubRoutingSource right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IotHubRoutingSource"/> values are not the same. </summary>
        public static bool operator !=(IotHubRoutingSource left, IotHubRoutingSource right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IotHubRoutingSource"/>. </summary>
        public static implicit operator IotHubRoutingSource(string value) => new IotHubRoutingSource(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IotHubRoutingSource other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IotHubRoutingSource other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
