// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.IotHub.Models
{
    public partial class IotHubRoutingProperties : IUtf8JsonSerializable, IJsonModel<IotHubRoutingProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<IotHubRoutingProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<IotHubRoutingProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<IotHubRoutingProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(IotHubRoutingProperties)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Endpoints))
            {
                writer.WritePropertyName("endpoints"u8);
                writer.WriteObjectValue(Endpoints, options);
            }
            if (Optional.IsCollectionDefined(Routes))
            {
                writer.WritePropertyName("routes"u8);
                writer.WriteStartArray();
                foreach (var item in Routes)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(FallbackRoute))
            {
                writer.WritePropertyName("fallbackRoute"u8);
                writer.WriteObjectValue(FallbackRoute, options);
            }
            if (Optional.IsCollectionDefined(Enrichments))
            {
                writer.WritePropertyName("enrichments"u8);
                writer.WriteStartArray();
                foreach (var item in Enrichments)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        IotHubRoutingProperties IJsonModel<IotHubRoutingProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<IotHubRoutingProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(IotHubRoutingProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeIotHubRoutingProperties(document.RootElement, options);
        }

        internal static IotHubRoutingProperties DeserializeIotHubRoutingProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            RoutingEndpoints endpoints = default;
            IList<RoutingRuleProperties> routes = default;
            IotHubFallbackRouteProperties fallbackRoute = default;
            IList<IotHubEnrichmentProperties> enrichments = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("endpoints"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    endpoints = RoutingEndpoints.DeserializeRoutingEndpoints(property.Value, options);
                    continue;
                }
                if (property.NameEquals("routes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<RoutingRuleProperties> array = new List<RoutingRuleProperties>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(RoutingRuleProperties.DeserializeRoutingRuleProperties(item, options));
                    }
                    routes = array;
                    continue;
                }
                if (property.NameEquals("fallbackRoute"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    fallbackRoute = IotHubFallbackRouteProperties.DeserializeIotHubFallbackRouteProperties(property.Value, options);
                    continue;
                }
                if (property.NameEquals("enrichments"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<IotHubEnrichmentProperties> array = new List<IotHubEnrichmentProperties>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(IotHubEnrichmentProperties.DeserializeIotHubEnrichmentProperties(item, options));
                    }
                    enrichments = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new IotHubRoutingProperties(endpoints, routes ?? new ChangeTrackingList<RoutingRuleProperties>(), fallbackRoute, enrichments ?? new ChangeTrackingList<IotHubEnrichmentProperties>(), serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<IotHubRoutingProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<IotHubRoutingProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(IotHubRoutingProperties)} does not support writing '{options.Format}' format.");
            }
        }

        IotHubRoutingProperties IPersistableModel<IotHubRoutingProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<IotHubRoutingProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeIotHubRoutingProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(IotHubRoutingProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<IotHubRoutingProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
