// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.IotHub.Models
{
    /// <summary> The role of the region, can be either primary or secondary. The primary region is where the IoT hub is currently provisioned. The secondary region is the Azure disaster recovery (DR) paired region and also the region where the IoT hub can failover to. </summary>
    public readonly partial struct IotHubReplicaRoleType : IEquatable<IotHubReplicaRoleType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IotHubReplicaRoleType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IotHubReplicaRoleType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PrimaryValue = "primary";
        private const string SecondaryValue = "secondary";

        /// <summary> primary. </summary>
        public static IotHubReplicaRoleType Primary { get; } = new IotHubReplicaRoleType(PrimaryValue);
        /// <summary> secondary. </summary>
        public static IotHubReplicaRoleType Secondary { get; } = new IotHubReplicaRoleType(SecondaryValue);
        /// <summary> Determines if two <see cref="IotHubReplicaRoleType"/> values are the same. </summary>
        public static bool operator ==(IotHubReplicaRoleType left, IotHubReplicaRoleType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IotHubReplicaRoleType"/> values are not the same. </summary>
        public static bool operator !=(IotHubReplicaRoleType left, IotHubReplicaRoleType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IotHubReplicaRoleType"/>. </summary>
        public static implicit operator IotHubReplicaRoleType(string value) => new IotHubReplicaRoleType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IotHubReplicaRoleType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IotHubReplicaRoleType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
