// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.IotHub.Models
{
    /// <summary> Identity registry statistics. </summary>
    public partial class IotHubRegistryStatistics
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="IotHubRegistryStatistics"/>. </summary>
        internal IotHubRegistryStatistics()
        {
        }

        /// <summary> Initializes a new instance of <see cref="IotHubRegistryStatistics"/>. </summary>
        /// <param name="totalDeviceCount"> The total count of devices in the identity registry. </param>
        /// <param name="enabledDeviceCount"> The count of enabled devices in the identity registry. </param>
        /// <param name="disabledDeviceCount"> The count of disabled devices in the identity registry. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal IotHubRegistryStatistics(long? totalDeviceCount, long? enabledDeviceCount, long? disabledDeviceCount, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TotalDeviceCount = totalDeviceCount;
            EnabledDeviceCount = enabledDeviceCount;
            DisabledDeviceCount = disabledDeviceCount;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The total count of devices in the identity registry. </summary>
        public long? TotalDeviceCount { get; }
        /// <summary> The count of enabled devices in the identity registry. </summary>
        public long? EnabledDeviceCount { get; }
        /// <summary> The count of disabled devices in the identity registry. </summary>
        public long? DisabledDeviceCount { get; }
    }
}
