// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.IotHub.Models
{
    /// <summary> Default Action for Network Rule Set. </summary>
    public readonly partial struct IotHubNetworkRuleSetDefaultAction : IEquatable<IotHubNetworkRuleSetDefaultAction>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IotHubNetworkRuleSetDefaultAction"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IotHubNetworkRuleSetDefaultAction(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DenyValue = "Deny";
        private const string AllowValue = "Allow";

        /// <summary> Deny. </summary>
        public static IotHubNetworkRuleSetDefaultAction Deny { get; } = new IotHubNetworkRuleSetDefaultAction(DenyValue);
        /// <summary> Allow. </summary>
        public static IotHubNetworkRuleSetDefaultAction Allow { get; } = new IotHubNetworkRuleSetDefaultAction(AllowValue);
        /// <summary> Determines if two <see cref="IotHubNetworkRuleSetDefaultAction"/> values are the same. </summary>
        public static bool operator ==(IotHubNetworkRuleSetDefaultAction left, IotHubNetworkRuleSetDefaultAction right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IotHubNetworkRuleSetDefaultAction"/> values are not the same. </summary>
        public static bool operator !=(IotHubNetworkRuleSetDefaultAction left, IotHubNetworkRuleSetDefaultAction right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IotHubNetworkRuleSetDefaultAction"/>. </summary>
        public static implicit operator IotHubNetworkRuleSetDefaultAction(string value) => new IotHubNetworkRuleSetDefaultAction(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IotHubNetworkRuleSetDefaultAction other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IotHubNetworkRuleSetDefaultAction other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
