// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.IotHub.Models
{
    /// <summary> IP Filter Action. </summary>
    public readonly partial struct IotHubNetworkRuleIPAction : IEquatable<IotHubNetworkRuleIPAction>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IotHubNetworkRuleIPAction"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IotHubNetworkRuleIPAction(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AllowValue = "Allow";

        /// <summary> Allow. </summary>
        public static IotHubNetworkRuleIPAction Allow { get; } = new IotHubNetworkRuleIPAction(AllowValue);
        /// <summary> Determines if two <see cref="IotHubNetworkRuleIPAction"/> values are the same. </summary>
        public static bool operator ==(IotHubNetworkRuleIPAction left, IotHubNetworkRuleIPAction right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IotHubNetworkRuleIPAction"/> values are not the same. </summary>
        public static bool operator !=(IotHubNetworkRuleIPAction left, IotHubNetworkRuleIPAction right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IotHubNetworkRuleIPAction"/>. </summary>
        public static implicit operator IotHubNetworkRuleIPAction(string value) => new IotHubNetworkRuleIPAction(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IotHubNetworkRuleIPAction other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IotHubNetworkRuleIPAction other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
