// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.IotHub.Models
{
    internal static partial class IotHubNameUnavailableReasonExtensions
    {
        public static string ToSerialString(this IotHubNameUnavailableReason value) => value switch
        {
            IotHubNameUnavailableReason.Invalid => "Invalid",
            IotHubNameUnavailableReason.AlreadyExists => "AlreadyExists",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown IotHubNameUnavailableReason value.")
        };

        public static IotHubNameUnavailableReason ToIotHubNameUnavailableReason(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Invalid")) return IotHubNameUnavailableReason.Invalid;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "AlreadyExists")) return IotHubNameUnavailableReason.AlreadyExists;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown IotHubNameUnavailableReason value.");
        }
    }
}
