// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.IotHub.Models
{
    /// <summary> The type of the job. </summary>
    public readonly partial struct IotHubJobType : IEquatable<IotHubJobType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IotHubJobType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IotHubJobType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "unknown";
        private const string ExportValue = "export";
        private const string ImportValue = "import";
        private const string BackupValue = "backup";
        private const string ReadDevicePropertiesValue = "readDeviceProperties";
        private const string WriteDevicePropertiesValue = "writeDeviceProperties";
        private const string UpdateDeviceConfigurationValue = "updateDeviceConfiguration";
        private const string RebootDeviceValue = "rebootDevice";
        private const string FactoryResetDeviceValue = "factoryResetDevice";
        private const string FirmwareUpdateValue = "firmwareUpdate";

        /// <summary> unknown. </summary>
        public static IotHubJobType Unknown { get; } = new IotHubJobType(UnknownValue);
        /// <summary> export. </summary>
        public static IotHubJobType Export { get; } = new IotHubJobType(ExportValue);
        /// <summary> import. </summary>
        public static IotHubJobType Import { get; } = new IotHubJobType(ImportValue);
        /// <summary> backup. </summary>
        public static IotHubJobType Backup { get; } = new IotHubJobType(BackupValue);
        /// <summary> readDeviceProperties. </summary>
        public static IotHubJobType ReadDeviceProperties { get; } = new IotHubJobType(ReadDevicePropertiesValue);
        /// <summary> writeDeviceProperties. </summary>
        public static IotHubJobType WriteDeviceProperties { get; } = new IotHubJobType(WriteDevicePropertiesValue);
        /// <summary> updateDeviceConfiguration. </summary>
        public static IotHubJobType UpdateDeviceConfiguration { get; } = new IotHubJobType(UpdateDeviceConfigurationValue);
        /// <summary> rebootDevice. </summary>
        public static IotHubJobType RebootDevice { get; } = new IotHubJobType(RebootDeviceValue);
        /// <summary> factoryResetDevice. </summary>
        public static IotHubJobType FactoryResetDevice { get; } = new IotHubJobType(FactoryResetDeviceValue);
        /// <summary> firmwareUpdate. </summary>
        public static IotHubJobType FirmwareUpdate { get; } = new IotHubJobType(FirmwareUpdateValue);
        /// <summary> Determines if two <see cref="IotHubJobType"/> values are the same. </summary>
        public static bool operator ==(IotHubJobType left, IotHubJobType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IotHubJobType"/> values are not the same. </summary>
        public static bool operator !=(IotHubJobType left, IotHubJobType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IotHubJobType"/>. </summary>
        public static implicit operator IotHubJobType(string value) => new IotHubJobType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IotHubJobType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IotHubJobType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
