// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.IotHub.Models
{
    internal static partial class IotHubJobStatusExtensions
    {
        public static string ToSerialString(this IotHubJobStatus value) => value switch
        {
            IotHubJobStatus.Unknown => "unknown",
            IotHubJobStatus.Enqueued => "enqueued",
            IotHubJobStatus.Running => "running",
            IotHubJobStatus.Completed => "completed",
            IotHubJobStatus.Failed => "failed",
            IotHubJobStatus.Cancelled => "cancelled",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown IotHubJobStatus value.")
        };

        public static IotHubJobStatus ToIotHubJobStatus(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "unknown")) return IotHubJobStatus.Unknown;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "enqueued")) return IotHubJobStatus.Enqueued;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "running")) return IotHubJobStatus.Running;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "completed")) return IotHubJobStatus.Completed;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "failed")) return IotHubJobStatus.Failed;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "cancelled")) return IotHubJobStatus.Cancelled;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown IotHubJobStatus value.");
        }
    }
}
