// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.IotHub.Models
{
    internal static partial class IotHubIPFilterActionTypeExtensions
    {
        public static string ToSerialString(this IotHubIPFilterActionType value) => value switch
        {
            IotHubIPFilterActionType.Accept => "Accept",
            IotHubIPFilterActionType.Reject => "Reject",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown IotHubIPFilterActionType value.")
        };

        public static IotHubIPFilterActionType ToIotHubIPFilterActionType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Accept")) return IotHubIPFilterActionType.Accept;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Reject")) return IotHubIPFilterActionType.Reject;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown IotHubIPFilterActionType value.");
        }
    }
}
