// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.IotHub.Models
{
    /// <summary> The properties of an enrichment that your IoT hub applies to messages delivered to endpoints. </summary>
    public partial class IotHubEnrichmentProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="IotHubEnrichmentProperties"/>. </summary>
        /// <param name="key"> The key or name for the enrichment property. </param>
        /// <param name="value"> The value for the enrichment property. </param>
        /// <param name="endpointNames"> The list of endpoints for which the enrichment is applied to the message. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="key"/>, <paramref name="value"/> or <paramref name="endpointNames"/> is null. </exception>
        public IotHubEnrichmentProperties(string key, string value, IEnumerable<string> endpointNames)
        {
            Argument.AssertNotNull(key, nameof(key));
            Argument.AssertNotNull(value, nameof(value));
            Argument.AssertNotNull(endpointNames, nameof(endpointNames));

            Key = key;
            Value = value;
            EndpointNames = endpointNames.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="IotHubEnrichmentProperties"/>. </summary>
        /// <param name="key"> The key or name for the enrichment property. </param>
        /// <param name="value"> The value for the enrichment property. </param>
        /// <param name="endpointNames"> The list of endpoints for which the enrichment is applied to the message. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal IotHubEnrichmentProperties(string key, string value, IList<string> endpointNames, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Key = key;
            Value = value;
            EndpointNames = endpointNames;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="IotHubEnrichmentProperties"/> for deserialization. </summary>
        internal IotHubEnrichmentProperties()
        {
        }

        /// <summary> The key or name for the enrichment property. </summary>
        public string Key { get; set; }
        /// <summary> The value for the enrichment property. </summary>
        public string Value { get; set; }
        /// <summary> The list of endpoints for which the enrichment is applied to the message. </summary>
        public IList<string> EndpointNames { get; }
    }
}
