// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.IotHub.Models
{
    /// <summary> Health statuses have following meanings. The 'healthy' status shows that the endpoint is accepting messages as expected. The 'unhealthy' status shows that the endpoint is not accepting messages as expected and IoT Hub is retrying to send data to this endpoint. The status of an unhealthy endpoint will be updated to healthy when IoT Hub has established an eventually consistent state of health. The 'dead' status shows that the endpoint is not accepting messages, after IoT Hub retried sending messages for the retrial period. See IoT Hub metrics to identify errors and monitor issues with endpoints. The 'unknown' status shows that the IoT Hub has not established a connection with the endpoint. No messages have been delivered to or rejected from this endpoint. </summary>
    public readonly partial struct IotHubEndpointHealthStatus : IEquatable<IotHubEndpointHealthStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IotHubEndpointHealthStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IotHubEndpointHealthStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "unknown";
        private const string HealthyValue = "healthy";
        private const string DegradedValue = "degraded";
        private const string UnhealthyValue = "unhealthy";
        private const string DeadValue = "dead";

        /// <summary> unknown. </summary>
        public static IotHubEndpointHealthStatus Unknown { get; } = new IotHubEndpointHealthStatus(UnknownValue);
        /// <summary> healthy. </summary>
        public static IotHubEndpointHealthStatus Healthy { get; } = new IotHubEndpointHealthStatus(HealthyValue);
        /// <summary> degraded. </summary>
        public static IotHubEndpointHealthStatus Degraded { get; } = new IotHubEndpointHealthStatus(DegradedValue);
        /// <summary> unhealthy. </summary>
        public static IotHubEndpointHealthStatus Unhealthy { get; } = new IotHubEndpointHealthStatus(UnhealthyValue);
        /// <summary> dead. </summary>
        public static IotHubEndpointHealthStatus Dead { get; } = new IotHubEndpointHealthStatus(DeadValue);
        /// <summary> Determines if two <see cref="IotHubEndpointHealthStatus"/> values are the same. </summary>
        public static bool operator ==(IotHubEndpointHealthStatus left, IotHubEndpointHealthStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IotHubEndpointHealthStatus"/> values are not the same. </summary>
        public static bool operator !=(IotHubEndpointHealthStatus left, IotHubEndpointHealthStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IotHubEndpointHealthStatus"/>. </summary>
        public static implicit operator IotHubEndpointHealthStatus(string value) => new IotHubEndpointHealthStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IotHubEndpointHealthStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IotHubEndpointHealthStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
