// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.IotHub.Models
{
    /// <summary> The JSON-serialized array of EndpointHealthData objects with a next link. </summary>
    internal partial class IotHubEndpointHealthInfoListResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="IotHubEndpointHealthInfoListResult"/>. </summary>
        internal IotHubEndpointHealthInfoListResult()
        {
            Value = new ChangeTrackingList<IotHubEndpointHealthInfo>();
        }

        /// <summary> Initializes a new instance of <see cref="IotHubEndpointHealthInfoListResult"/>. </summary>
        /// <param name="value"> JSON-serialized array of Endpoint health data. </param>
        /// <param name="nextLink"> Link to more results. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal IotHubEndpointHealthInfoListResult(IReadOnlyList<IotHubEndpointHealthInfo> value, string nextLink, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Value = value;
            NextLink = nextLink;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> JSON-serialized array of Endpoint health data. </summary>
        public IReadOnlyList<IotHubEndpointHealthInfo> Value { get; }
        /// <summary> Link to more results. </summary>
        public string NextLink { get; }
    }
}
