// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.IotHub.Models
{
    public partial class IotHubEndpointHealthInfo : IUtf8JsonSerializable, IJsonModel<IotHubEndpointHealthInfo>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<IotHubEndpointHealthInfo>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<IotHubEndpointHealthInfo>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<IotHubEndpointHealthInfo>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(IotHubEndpointHealthInfo)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(EndpointId))
            {
                writer.WritePropertyName("endpointId"u8);
                writer.WriteStringValue(EndpointId);
            }
            if (Optional.IsDefined(HealthStatus))
            {
                writer.WritePropertyName("healthStatus"u8);
                writer.WriteStringValue(HealthStatus.Value.ToString());
            }
            if (Optional.IsDefined(LastKnownError))
            {
                writer.WritePropertyName("lastKnownError"u8);
                writer.WriteStringValue(LastKnownError);
            }
            if (Optional.IsDefined(LastKnownErrorOn))
            {
                writer.WritePropertyName("lastKnownErrorTime"u8);
                writer.WriteStringValue(LastKnownErrorOn.Value, "R");
            }
            if (Optional.IsDefined(LastSuccessfulSendAttemptOn))
            {
                writer.WritePropertyName("lastSuccessfulSendAttemptTime"u8);
                writer.WriteStringValue(LastSuccessfulSendAttemptOn.Value, "R");
            }
            if (Optional.IsDefined(LastSendAttemptOn))
            {
                writer.WritePropertyName("lastSendAttemptTime"u8);
                writer.WriteStringValue(LastSendAttemptOn.Value, "R");
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        IotHubEndpointHealthInfo IJsonModel<IotHubEndpointHealthInfo>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<IotHubEndpointHealthInfo>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(IotHubEndpointHealthInfo)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeIotHubEndpointHealthInfo(document.RootElement, options);
        }

        internal static IotHubEndpointHealthInfo DeserializeIotHubEndpointHealthInfo(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string endpointId = default;
            IotHubEndpointHealthStatus? healthStatus = default;
            string lastKnownError = default;
            DateTimeOffset? lastKnownErrorTime = default;
            DateTimeOffset? lastSuccessfulSendAttemptTime = default;
            DateTimeOffset? lastSendAttemptTime = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("endpointId"u8))
                {
                    endpointId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("healthStatus"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    healthStatus = new IotHubEndpointHealthStatus(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("lastKnownError"u8))
                {
                    lastKnownError = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("lastKnownErrorTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lastKnownErrorTime = property.Value.GetDateTimeOffset("R");
                    continue;
                }
                if (property.NameEquals("lastSuccessfulSendAttemptTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lastSuccessfulSendAttemptTime = property.Value.GetDateTimeOffset("R");
                    continue;
                }
                if (property.NameEquals("lastSendAttemptTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lastSendAttemptTime = property.Value.GetDateTimeOffset("R");
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new IotHubEndpointHealthInfo(
                endpointId,
                healthStatus,
                lastKnownError,
                lastKnownErrorTime,
                lastSuccessfulSendAttemptTime,
                lastSendAttemptTime,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<IotHubEndpointHealthInfo>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<IotHubEndpointHealthInfo>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(IotHubEndpointHealthInfo)} does not support writing '{options.Format}' format.");
            }
        }

        IotHubEndpointHealthInfo IPersistableModel<IotHubEndpointHealthInfo>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<IotHubEndpointHealthInfo>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeIotHubEndpointHealthInfo(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(IotHubEndpointHealthInfo)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<IotHubEndpointHealthInfo>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
