// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.IotHub.Models
{
    /// <summary> The capabilities and features enabled for the IoT hub. </summary>
    public readonly partial struct IotHubCapability : IEquatable<IotHubCapability>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IotHubCapability"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IotHubCapability(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string DeviceManagementValue = "DeviceManagement";

        /// <summary> None. </summary>
        public static IotHubCapability None { get; } = new IotHubCapability(NoneValue);
        /// <summary> DeviceManagement. </summary>
        public static IotHubCapability DeviceManagement { get; } = new IotHubCapability(DeviceManagementValue);
        /// <summary> Determines if two <see cref="IotHubCapability"/> values are the same. </summary>
        public static bool operator ==(IotHubCapability left, IotHubCapability right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IotHubCapability"/> values are not the same. </summary>
        public static bool operator !=(IotHubCapability left, IotHubCapability right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IotHubCapability"/>. </summary>
        public static implicit operator IotHubCapability(string value) => new IotHubCapability(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IotHubCapability other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IotHubCapability other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
