// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.IotHub.Models
{
    /// <summary> Specifies authentication type being used for connecting to the storage account. </summary>
    public readonly partial struct IotHubAuthenticationType : IEquatable<IotHubAuthenticationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IotHubAuthenticationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IotHubAuthenticationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string KeyBasedValue = "keyBased";
        private const string IdentityBasedValue = "identityBased";

        /// <summary> keyBased. </summary>
        public static IotHubAuthenticationType KeyBased { get; } = new IotHubAuthenticationType(KeyBasedValue);
        /// <summary> identityBased. </summary>
        public static IotHubAuthenticationType IdentityBased { get; } = new IotHubAuthenticationType(IdentityBasedValue);
        /// <summary> Determines if two <see cref="IotHubAuthenticationType"/> values are the same. </summary>
        public static bool operator ==(IotHubAuthenticationType left, IotHubAuthenticationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IotHubAuthenticationType"/> values are not the same. </summary>
        public static bool operator !=(IotHubAuthenticationType left, IotHubAuthenticationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IotHubAuthenticationType"/>. </summary>
        public static implicit operator IotHubAuthenticationType(string value) => new IotHubAuthenticationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IotHubAuthenticationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IotHubAuthenticationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
