// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.IotHub
{
    internal class IotHubPrivateEndpointConnectionOperationSource : IOperationSource<IotHubPrivateEndpointConnectionResource>
    {
        private readonly ArmClient _client;

        internal IotHubPrivateEndpointConnectionOperationSource(ArmClient client)
        {
            _client = client;
        }

        IotHubPrivateEndpointConnectionResource IOperationSource<IotHubPrivateEndpointConnectionResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = IotHubPrivateEndpointConnectionData.DeserializeIotHubPrivateEndpointConnectionData(document.RootElement);
            return new IotHubPrivateEndpointConnectionResource(_client, data);
        }

        async ValueTask<IotHubPrivateEndpointConnectionResource> IOperationSource<IotHubPrivateEndpointConnectionResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = IotHubPrivateEndpointConnectionData.DeserializeIotHubPrivateEndpointConnectionData(document.RootElement);
            return new IotHubPrivateEndpointConnectionResource(_client, data);
        }
    }
}
