// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.IotHub.Models;

namespace Azure.ResourceManager.IotHub.Samples
{
    public partial class Sample_EventHubConsumerGroupInfoResource
    {
        // IotHubResource_ListEventHubConsumerGroups
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_IotHubResourceListEventHubConsumerGroups()
        {
            // Generated from example definition: specification/iothub/resource-manager/Microsoft.Devices/stable/2023-06-30/examples/iothub_getconsumergroup.json
            // this example is just showing the usage of "IotHubResource_GetEventHubConsumerGroup" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this EventHubConsumerGroupInfoResource created on azure
            // for more information of creating EventHubConsumerGroupInfoResource, please refer to the document of EventHubConsumerGroupInfoResource
            string subscriptionId = "91d12660-3dec-467a-be2a-213b5544ddc0";
            string resourceGroupName = "myResourceGroup";
            string resourceName = "testHub";
            string eventHubEndpointName = "events";
            string name = "test";
            ResourceIdentifier eventHubConsumerGroupInfoResourceId = EventHubConsumerGroupInfoResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, eventHubEndpointName, name);
            EventHubConsumerGroupInfoResource eventHubConsumerGroupInfo = client.GetEventHubConsumerGroupInfoResource(eventHubConsumerGroupInfoResourceId);

            // invoke the operation
            EventHubConsumerGroupInfoResource result = await eventHubConsumerGroupInfo.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            EventHubConsumerGroupInfoData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // IotHubResource_CreateEventHubConsumerGroup
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_IotHubResourceCreateEventHubConsumerGroup()
        {
            // Generated from example definition: specification/iothub/resource-manager/Microsoft.Devices/stable/2023-06-30/examples/iothub_createconsumergroup.json
            // this example is just showing the usage of "IotHubResource_CreateEventHubConsumerGroup" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this EventHubConsumerGroupInfoResource created on azure
            // for more information of creating EventHubConsumerGroupInfoResource, please refer to the document of EventHubConsumerGroupInfoResource
            string subscriptionId = "91d12660-3dec-467a-be2a-213b5544ddc0";
            string resourceGroupName = "myResourceGroup";
            string resourceName = "testHub";
            string eventHubEndpointName = "events";
            string name = "test";
            ResourceIdentifier eventHubConsumerGroupInfoResourceId = EventHubConsumerGroupInfoResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, eventHubEndpointName, name);
            EventHubConsumerGroupInfoResource eventHubConsumerGroupInfo = client.GetEventHubConsumerGroupInfoResource(eventHubConsumerGroupInfoResourceId);

            // invoke the operation
            EventHubConsumerGroupInfoCreateOrUpdateContent content = new EventHubConsumerGroupInfoCreateOrUpdateContent("test");
            ArmOperation<EventHubConsumerGroupInfoResource> lro = await eventHubConsumerGroupInfo.UpdateAsync(WaitUntil.Completed, content);
            EventHubConsumerGroupInfoResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            EventHubConsumerGroupInfoData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // IotHubResource_DeleteEventHubConsumerGroup
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_IotHubResourceDeleteEventHubConsumerGroup()
        {
            // Generated from example definition: specification/iothub/resource-manager/Microsoft.Devices/stable/2023-06-30/examples/iothub_deleteconsumergroup.json
            // this example is just showing the usage of "IotHubResource_DeleteEventHubConsumerGroup" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this EventHubConsumerGroupInfoResource created on azure
            // for more information of creating EventHubConsumerGroupInfoResource, please refer to the document of EventHubConsumerGroupInfoResource
            string subscriptionId = "91d12660-3dec-467a-be2a-213b5544ddc0";
            string resourceGroupName = "myResourceGroup";
            string resourceName = "testHub";
            string eventHubEndpointName = "events";
            string name = "test";
            ResourceIdentifier eventHubConsumerGroupInfoResourceId = EventHubConsumerGroupInfoResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, eventHubEndpointName, name);
            EventHubConsumerGroupInfoResource eventHubConsumerGroupInfo = client.GetEventHubConsumerGroupInfoResource(eventHubConsumerGroupInfoResourceId);

            // invoke the operation
            await eventHubConsumerGroupInfo.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
