// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.IotCentral.Models
{
    /// <summary> Whether requests from the public network are allowed. </summary>
    public readonly partial struct IotCentralPublicNetworkAccess : IEquatable<IotCentralPublicNetworkAccess>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IotCentralPublicNetworkAccess"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IotCentralPublicNetworkAccess(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static IotCentralPublicNetworkAccess Enabled { get; } = new IotCentralPublicNetworkAccess(EnabledValue);
        /// <summary> Disabled. </summary>
        public static IotCentralPublicNetworkAccess Disabled { get; } = new IotCentralPublicNetworkAccess(DisabledValue);
        /// <summary> Determines if two <see cref="IotCentralPublicNetworkAccess"/> values are the same. </summary>
        public static bool operator ==(IotCentralPublicNetworkAccess left, IotCentralPublicNetworkAccess right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IotCentralPublicNetworkAccess"/> values are not the same. </summary>
        public static bool operator !=(IotCentralPublicNetworkAccess left, IotCentralPublicNetworkAccess right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IotCentralPublicNetworkAccess"/>. </summary>
        public static implicit operator IotCentralPublicNetworkAccess(string value) => new IotCentralPublicNetworkAccess(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IotCentralPublicNetworkAccess other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IotCentralPublicNetworkAccess other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
