// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.IotCentral.Models
{
    /// <summary> The private endpoint connection status. </summary>
    public readonly partial struct IotCentralPrivateEndpointServiceConnectionStatus : IEquatable<IotCentralPrivateEndpointServiceConnectionStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IotCentralPrivateEndpointServiceConnectionStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IotCentralPrivateEndpointServiceConnectionStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PendingValue = "Pending";
        private const string ApprovedValue = "Approved";
        private const string RejectedValue = "Rejected";

        /// <summary> Pending. </summary>
        public static IotCentralPrivateEndpointServiceConnectionStatus Pending { get; } = new IotCentralPrivateEndpointServiceConnectionStatus(PendingValue);
        /// <summary> Approved. </summary>
        public static IotCentralPrivateEndpointServiceConnectionStatus Approved { get; } = new IotCentralPrivateEndpointServiceConnectionStatus(ApprovedValue);
        /// <summary> Rejected. </summary>
        public static IotCentralPrivateEndpointServiceConnectionStatus Rejected { get; } = new IotCentralPrivateEndpointServiceConnectionStatus(RejectedValue);
        /// <summary> Determines if two <see cref="IotCentralPrivateEndpointServiceConnectionStatus"/> values are the same. </summary>
        public static bool operator ==(IotCentralPrivateEndpointServiceConnectionStatus left, IotCentralPrivateEndpointServiceConnectionStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IotCentralPrivateEndpointServiceConnectionStatus"/> values are not the same. </summary>
        public static bool operator !=(IotCentralPrivateEndpointServiceConnectionStatus left, IotCentralPrivateEndpointServiceConnectionStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IotCentralPrivateEndpointServiceConnectionStatus"/>. </summary>
        public static implicit operator IotCentralPrivateEndpointServiceConnectionStatus(string value) => new IotCentralPrivateEndpointServiceConnectionStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IotCentralPrivateEndpointServiceConnectionStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IotCentralPrivateEndpointServiceConnectionStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
