// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.IotCentral.Models
{
    public partial class IotCentralNetworkRuleSets : IUtf8JsonSerializable, IJsonModel<IotCentralNetworkRuleSets>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<IotCentralNetworkRuleSets>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<IotCentralNetworkRuleSets>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<IotCentralNetworkRuleSets>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(IotCentralNetworkRuleSets)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(ApplyToDevices))
            {
                writer.WritePropertyName("applyToDevices"u8);
                writer.WriteBooleanValue(ApplyToDevices.Value);
            }
            if (Optional.IsDefined(ApplyToIotCentral))
            {
                writer.WritePropertyName("applyToIoTCentral"u8);
                writer.WriteBooleanValue(ApplyToIotCentral.Value);
            }
            if (Optional.IsDefined(DefaultAction))
            {
                writer.WritePropertyName("defaultAction"u8);
                writer.WriteStringValue(DefaultAction.Value.ToString());
            }
            if (Optional.IsCollectionDefined(IPRules))
            {
                writer.WritePropertyName("ipRules"u8);
                writer.WriteStartArray();
                foreach (var item in IPRules)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        IotCentralNetworkRuleSets IJsonModel<IotCentralNetworkRuleSets>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<IotCentralNetworkRuleSets>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(IotCentralNetworkRuleSets)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeIotCentralNetworkRuleSets(document.RootElement, options);
        }

        internal static IotCentralNetworkRuleSets DeserializeIotCentralNetworkRuleSets(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            bool? applyToDevices = default;
            bool? applyToIoTCentral = default;
            IotCentralNetworkAction? defaultAction = default;
            IList<IotCentralNetworkRuleSetIPRule> ipRules = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("applyToDevices"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    applyToDevices = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("applyToIoTCentral"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    applyToIoTCentral = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("defaultAction"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    defaultAction = new IotCentralNetworkAction(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("ipRules"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<IotCentralNetworkRuleSetIPRule> array = new List<IotCentralNetworkRuleSetIPRule>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(IotCentralNetworkRuleSetIPRule.DeserializeIotCentralNetworkRuleSetIPRule(item, options));
                    }
                    ipRules = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new IotCentralNetworkRuleSets(applyToDevices, applyToIoTCentral, defaultAction, ipRules ?? new ChangeTrackingList<IotCentralNetworkRuleSetIPRule>(), serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<IotCentralNetworkRuleSets>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<IotCentralNetworkRuleSets>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(IotCentralNetworkRuleSets)} does not support writing '{options.Format}' format.");
            }
        }

        IotCentralNetworkRuleSets IPersistableModel<IotCentralNetworkRuleSets>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<IotCentralNetworkRuleSets>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeIotCentralNetworkRuleSets(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(IotCentralNetworkRuleSets)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<IotCentralNetworkRuleSets>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
