// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.IotCentral.Models
{
    /// <summary> An object for an IP range that will be allowed access. </summary>
    public partial class IotCentralNetworkRuleSetIPRule
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="IotCentralNetworkRuleSetIPRule"/>. </summary>
        public IotCentralNetworkRuleSetIPRule()
        {
        }

        /// <summary> Initializes a new instance of <see cref="IotCentralNetworkRuleSetIPRule"/>. </summary>
        /// <param name="filterName"> The readable name of the IP rule. </param>
        /// <param name="ipMask"> The CIDR block defining the IP range. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal IotCentralNetworkRuleSetIPRule(string filterName, string ipMask, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            FilterName = filterName;
            IPMask = ipMask;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The readable name of the IP rule. </summary>
        public string FilterName { get; set; }
        /// <summary> The CIDR block defining the IP range. </summary>
        public string IPMask { get; set; }
    }
}
