// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.IotCentral.Models
{
    /// <summary> Whether to allow or deny network traffic. </summary>
    public readonly partial struct IotCentralNetworkAction : IEquatable<IotCentralNetworkAction>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IotCentralNetworkAction"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IotCentralNetworkAction(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AllowValue = "Allow";
        private const string DenyValue = "Deny";

        /// <summary> Allow. </summary>
        public static IotCentralNetworkAction Allow { get; } = new IotCentralNetworkAction(AllowValue);
        /// <summary> Deny. </summary>
        public static IotCentralNetworkAction Deny { get; } = new IotCentralNetworkAction(DenyValue);
        /// <summary> Determines if two <see cref="IotCentralNetworkAction"/> values are the same. </summary>
        public static bool operator ==(IotCentralNetworkAction left, IotCentralNetworkAction right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IotCentralNetworkAction"/> values are not the same. </summary>
        public static bool operator !=(IotCentralNetworkAction left, IotCentralNetworkAction right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IotCentralNetworkAction"/>. </summary>
        public static implicit operator IotCentralNetworkAction(string value) => new IotCentralNetworkAction(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IotCentralNetworkAction other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IotCentralNetworkAction other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
