// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.IotCentral.Models
{
    /// <summary> The current state of the application. </summary>
    public readonly partial struct IotCentralAppState : IEquatable<IotCentralAppState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IotCentralAppState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IotCentralAppState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreatedValue = "created";
        private const string SuspendedValue = "suspended";

        /// <summary> created. </summary>
        public static IotCentralAppState Created { get; } = new IotCentralAppState(CreatedValue);
        /// <summary> suspended. </summary>
        public static IotCentralAppState Suspended { get; } = new IotCentralAppState(SuspendedValue);
        /// <summary> Determines if two <see cref="IotCentralAppState"/> values are the same. </summary>
        public static bool operator ==(IotCentralAppState left, IotCentralAppState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IotCentralAppState"/> values are not the same. </summary>
        public static bool operator !=(IotCentralAppState left, IotCentralAppState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IotCentralAppState"/>. </summary>
        public static implicit operator IotCentralAppState(string value) => new IotCentralAppState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IotCentralAppState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IotCentralAppState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
