// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.IotCentral.Models
{
    /// <summary> The name of the SKU. </summary>
    public readonly partial struct IotCentralAppSku : IEquatable<IotCentralAppSku>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IotCentralAppSku"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IotCentralAppSku(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ST0Value = "ST0";
        private const string ST1Value = "ST1";
        private const string ST2Value = "ST2";

        /// <summary> ST0. </summary>
        public static IotCentralAppSku ST0 { get; } = new IotCentralAppSku(ST0Value);
        /// <summary> ST1. </summary>
        public static IotCentralAppSku ST1 { get; } = new IotCentralAppSku(ST1Value);
        /// <summary> ST2. </summary>
        public static IotCentralAppSku ST2 { get; } = new IotCentralAppSku(ST2Value);
        /// <summary> Determines if two <see cref="IotCentralAppSku"/> values are the same. </summary>
        public static bool operator ==(IotCentralAppSku left, IotCentralAppSku right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IotCentralAppSku"/> values are not the same. </summary>
        public static bool operator !=(IotCentralAppSku left, IotCentralAppSku right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IotCentralAppSku"/>. </summary>
        public static implicit operator IotCentralAppSku(string value) => new IotCentralAppSku(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IotCentralAppSku other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IotCentralAppSku other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
