// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.IotCentral.Models
{
    /// <summary> The properties indicating whether a given IoT Central application name or subdomain is available. </summary>
    public partial class IotCentralAppNameAvailabilityResponse
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="IotCentralAppNameAvailabilityResponse"/>. </summary>
        internal IotCentralAppNameAvailabilityResponse()
        {
        }

        /// <summary> Initializes a new instance of <see cref="IotCentralAppNameAvailabilityResponse"/>. </summary>
        /// <param name="isNameAvailable"> The value which indicates whether the provided name is available. </param>
        /// <param name="iotCentralAppNameUnavailableReason"> The reason for unavailability. </param>
        /// <param name="message"> The detailed reason message. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal IotCentralAppNameAvailabilityResponse(bool? isNameAvailable, string iotCentralAppNameUnavailableReason, string message, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IsNameAvailable = isNameAvailable;
            IotCentralAppNameUnavailableReason = iotCentralAppNameUnavailableReason;
            Message = message;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The value which indicates whether the provided name is available. </summary>
        public bool? IsNameAvailable { get; }
        /// <summary> The reason for unavailability. </summary>
        public string IotCentralAppNameUnavailableReason { get; }
        /// <summary> The detailed reason message. </summary>
        public string Message { get; }
    }
}
