// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.IotCentral
{
    internal class IotCentralPrivateEndpointConnectionOperationSource : IOperationSource<IotCentralPrivateEndpointConnectionResource>
    {
        private readonly ArmClient _client;

        internal IotCentralPrivateEndpointConnectionOperationSource(ArmClient client)
        {
            _client = client;
        }

        IotCentralPrivateEndpointConnectionResource IOperationSource<IotCentralPrivateEndpointConnectionResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = IotCentralPrivateEndpointConnectionData.DeserializeIotCentralPrivateEndpointConnectionData(document.RootElement);
            return new IotCentralPrivateEndpointConnectionResource(_client, data);
        }

        async ValueTask<IotCentralPrivateEndpointConnectionResource> IOperationSource<IotCentralPrivateEndpointConnectionResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = IotCentralPrivateEndpointConnectionData.DeserializeIotCentralPrivateEndpointConnectionData(document.RootElement);
            return new IotCentralPrivateEndpointConnectionResource(_client, data);
        }
    }
}
