// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.IotCentral.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableIotCentralArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableIotCentralArmClient"/> class for mocking. </summary>
        protected MockableIotCentralArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableIotCentralArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableIotCentralArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableIotCentralArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing an <see cref="IotCentralAppResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="IotCentralAppResource.CreateResourceIdentifier" /> to create an <see cref="IotCentralAppResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="IotCentralAppResource"/> object. </returns>
        public virtual IotCentralAppResource GetIotCentralAppResource(ResourceIdentifier id)
        {
            IotCentralAppResource.ValidateResourceId(id);
            return new IotCentralAppResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="IotCentralPrivateEndpointConnectionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="IotCentralPrivateEndpointConnectionResource.CreateResourceIdentifier" /> to create an <see cref="IotCentralPrivateEndpointConnectionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="IotCentralPrivateEndpointConnectionResource"/> object. </returns>
        public virtual IotCentralPrivateEndpointConnectionResource GetIotCentralPrivateEndpointConnectionResource(ResourceIdentifier id)
        {
            IotCentralPrivateEndpointConnectionResource.ValidateResourceId(id);
            return new IotCentralPrivateEndpointConnectionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="IotCentralPrivateLinkResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="IotCentralPrivateLinkResource.CreateResourceIdentifier" /> to create an <see cref="IotCentralPrivateLinkResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="IotCentralPrivateLinkResource"/> object. </returns>
        public virtual IotCentralPrivateLinkResource GetIotCentralPrivateLinkResource(ResourceIdentifier id)
        {
            IotCentralPrivateLinkResource.ValidateResourceId(id);
            return new IotCentralPrivateLinkResource(Client, id);
        }
    }
}
