// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.IotCentral.Models;

namespace Azure.ResourceManager.IotCentral.Samples
{
    public partial class Sample_IotCentralPrivateEndpointConnectionResource
    {
        // PrivateEndpointConnections_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_PrivateEndpointConnectionsGet()
        {
            // Generated from example definition: specification/iotcentral/resource-manager/Microsoft.IoTCentral/preview/2021-11-01-preview/examples/PrivateEndpointConnections_Get.json
            // this example is just showing the usage of "PrivateEndpointConnections_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this IotCentralPrivateEndpointConnectionResource created on azure
            // for more information of creating IotCentralPrivateEndpointConnectionResource, please refer to the document of IotCentralPrivateEndpointConnectionResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "resRg";
            string resourceName = "myIoTCentralApp";
            string privateEndpointConnectionName = "myIoTCentralAppEndpoint";
            ResourceIdentifier iotCentralPrivateEndpointConnectionResourceId = IotCentralPrivateEndpointConnectionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, privateEndpointConnectionName);
            IotCentralPrivateEndpointConnectionResource iotCentralPrivateEndpointConnection = client.GetIotCentralPrivateEndpointConnectionResource(iotCentralPrivateEndpointConnectionResourceId);

            // invoke the operation
            IotCentralPrivateEndpointConnectionResource result = await iotCentralPrivateEndpointConnection.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            IotCentralPrivateEndpointConnectionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // PrivateEndpointConnections_Update
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_PrivateEndpointConnectionsUpdate()
        {
            // Generated from example definition: specification/iotcentral/resource-manager/Microsoft.IoTCentral/preview/2021-11-01-preview/examples/PrivateEndpointConnections_Update.json
            // this example is just showing the usage of "PrivateEndpointConnections_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this IotCentralPrivateEndpointConnectionResource created on azure
            // for more information of creating IotCentralPrivateEndpointConnectionResource, please refer to the document of IotCentralPrivateEndpointConnectionResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "resRg";
            string resourceName = "myIoTCentralApp";
            string privateEndpointConnectionName = "myIoTCentralAppEndpoint";
            ResourceIdentifier iotCentralPrivateEndpointConnectionResourceId = IotCentralPrivateEndpointConnectionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, privateEndpointConnectionName);
            IotCentralPrivateEndpointConnectionResource iotCentralPrivateEndpointConnection = client.GetIotCentralPrivateEndpointConnectionResource(iotCentralPrivateEndpointConnectionResourceId);

            // invoke the operation
            IotCentralPrivateEndpointConnectionData data = new IotCentralPrivateEndpointConnectionData()
            {
                ConnectionState = new IotCentralPrivateLinkServiceConnectionState()
                {
                    Status = IotCentralPrivateEndpointServiceConnectionStatus.Approved,
                    Description = "Auto-approved",
                    ActionsRequired = "None",
                },
            };
            ArmOperation<IotCentralPrivateEndpointConnectionResource> lro = await iotCentralPrivateEndpointConnection.UpdateAsync(WaitUntil.Completed, data);
            IotCentralPrivateEndpointConnectionResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            IotCentralPrivateEndpointConnectionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // PrivateEndpointConnections_Delete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_PrivateEndpointConnectionsDelete()
        {
            // Generated from example definition: specification/iotcentral/resource-manager/Microsoft.IoTCentral/preview/2021-11-01-preview/examples/PrivateEndpointConnections_Delete.json
            // this example is just showing the usage of "PrivateEndpointConnections_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this IotCentralPrivateEndpointConnectionResource created on azure
            // for more information of creating IotCentralPrivateEndpointConnectionResource, please refer to the document of IotCentralPrivateEndpointConnectionResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "resRg";
            string resourceName = "myIoTCentralApp";
            string privateEndpointConnectionName = "myIoTCentralAppEndpoint";
            ResourceIdentifier iotCentralPrivateEndpointConnectionResourceId = IotCentralPrivateEndpointConnectionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, privateEndpointConnectionName);
            IotCentralPrivateEndpointConnectionResource iotCentralPrivateEndpointConnection = client.GetIotCentralPrivateEndpointConnectionResource(iotCentralPrivateEndpointConnectionResourceId);

            // invoke the operation
            await iotCentralPrivateEndpointConnection.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
