// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.IotFirmwareDefense.Models
{
    /// <summary> Password hash resource. </summary>
    public partial class PasswordHashResult : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PasswordHashResult"/>. </summary>
        public PasswordHashResult()
        {
        }

        /// <summary> Initializes a new instance of <see cref="PasswordHashResult"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="passwordHashId"> ID for password hash. </param>
        /// <param name="filePath"> File path of the password hash. </param>
        /// <param name="salt"> Salt of the password hash. </param>
        /// <param name="hash"> Hash of the password. </param>
        /// <param name="context"> Context of password hash. </param>
        /// <param name="username"> User name of password hash. </param>
        /// <param name="algorithm"> Algorithm of the password hash. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PasswordHashResult(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string passwordHashId, string filePath, string salt, string hash, string context, string username, string algorithm, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            PasswordHashId = passwordHashId;
            FilePath = filePath;
            Salt = salt;
            Hash = hash;
            Context = context;
            Username = username;
            Algorithm = algorithm;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> ID for password hash. </summary>
        public string PasswordHashId { get; set; }
        /// <summary> File path of the password hash. </summary>
        public string FilePath { get; set; }
        /// <summary> Salt of the password hash. </summary>
        public string Salt { get; set; }
        /// <summary> Hash of the password. </summary>
        public string Hash { get; set; }
        /// <summary> Context of password hash. </summary>
        public string Context { get; set; }
        /// <summary> User name of password hash. </summary>
        public string Username { get; set; }
        /// <summary> Algorithm of the password hash. </summary>
        public string Algorithm { get; set; }
    }
}
