// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.IotFirmwareDefense.Models
{
    public partial class PasswordHashResult : IUtf8JsonSerializable, IJsonModel<PasswordHashResult>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<PasswordHashResult>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<PasswordHashResult>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PasswordHashResult>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PasswordHashResult)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(PasswordHashId))
            {
                if (PasswordHashId != null)
                {
                    writer.WritePropertyName("passwordHashId"u8);
                    writer.WriteStringValue(PasswordHashId);
                }
                else
                {
                    writer.WriteNull("passwordHashId");
                }
            }
            if (Optional.IsDefined(FilePath))
            {
                if (FilePath != null)
                {
                    writer.WritePropertyName("filePath"u8);
                    writer.WriteStringValue(FilePath);
                }
                else
                {
                    writer.WriteNull("filePath");
                }
            }
            if (Optional.IsDefined(Salt))
            {
                if (Salt != null)
                {
                    writer.WritePropertyName("salt"u8);
                    writer.WriteStringValue(Salt);
                }
                else
                {
                    writer.WriteNull("salt");
                }
            }
            if (Optional.IsDefined(Hash))
            {
                if (Hash != null)
                {
                    writer.WritePropertyName("hash"u8);
                    writer.WriteStringValue(Hash);
                }
                else
                {
                    writer.WriteNull("hash");
                }
            }
            if (Optional.IsDefined(Context))
            {
                if (Context != null)
                {
                    writer.WritePropertyName("context"u8);
                    writer.WriteStringValue(Context);
                }
                else
                {
                    writer.WriteNull("context");
                }
            }
            if (Optional.IsDefined(Username))
            {
                if (Username != null)
                {
                    writer.WritePropertyName("username"u8);
                    writer.WriteStringValue(Username);
                }
                else
                {
                    writer.WriteNull("username");
                }
            }
            if (Optional.IsDefined(Algorithm))
            {
                if (Algorithm != null)
                {
                    writer.WritePropertyName("algorithm"u8);
                    writer.WriteStringValue(Algorithm);
                }
                else
                {
                    writer.WriteNull("algorithm");
                }
            }
            writer.WriteEndObject();
        }

        PasswordHashResult IJsonModel<PasswordHashResult>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PasswordHashResult>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PasswordHashResult)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializePasswordHashResult(document.RootElement, options);
        }

        internal static PasswordHashResult DeserializePasswordHashResult(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            string passwordHashId = default;
            string filePath = default;
            string salt = default;
            string hash = default;
            string context = default;
            string username = default;
            string algorithm = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("passwordHashId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                passwordHashId = null;
                                continue;
                            }
                            passwordHashId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("filePath"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                filePath = null;
                                continue;
                            }
                            filePath = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("salt"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                salt = null;
                                continue;
                            }
                            salt = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("hash"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                hash = null;
                                continue;
                            }
                            hash = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("context"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                context = null;
                                continue;
                            }
                            context = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("username"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                username = null;
                                continue;
                            }
                            username = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("algorithm"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                algorithm = null;
                                continue;
                            }
                            algorithm = property0.Value.GetString();
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new PasswordHashResult(
                id,
                name,
                type,
                systemData,
                passwordHashId,
                filePath,
                salt,
                hash,
                context,
                username,
                algorithm,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<PasswordHashResult>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PasswordHashResult>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(PasswordHashResult)} does not support writing '{options.Format}' format.");
            }
        }

        PasswordHashResult IPersistableModel<PasswordHashResult>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PasswordHashResult>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializePasswordHashResult(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(PasswordHashResult)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<PasswordHashResult>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
