// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.IotFirmwareDefense.Models
{
    public partial class FirmwareSummary : IUtf8JsonSerializable, IJsonModel<FirmwareSummary>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<FirmwareSummary>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<FirmwareSummary>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FirmwareSummary>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FirmwareSummary)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (Optional.IsDefined(ExtractedSize))
            {
                if (ExtractedSize != null)
                {
                    writer.WritePropertyName("extractedSize"u8);
                    writer.WriteNumberValue(ExtractedSize.Value);
                }
                else
                {
                    writer.WriteNull("extractedSize");
                }
            }
            if (Optional.IsDefined(FileSize))
            {
                if (FileSize != null)
                {
                    writer.WritePropertyName("fileSize"u8);
                    writer.WriteNumberValue(FileSize.Value);
                }
                else
                {
                    writer.WriteNull("fileSize");
                }
            }
            if (Optional.IsDefined(ExtractedFileCount))
            {
                if (ExtractedFileCount != null)
                {
                    writer.WritePropertyName("extractedFileCount"u8);
                    writer.WriteNumberValue(ExtractedFileCount.Value);
                }
                else
                {
                    writer.WriteNull("extractedFileCount");
                }
            }
            if (Optional.IsDefined(ComponentCount))
            {
                if (ComponentCount != null)
                {
                    writer.WritePropertyName("componentCount"u8);
                    writer.WriteNumberValue(ComponentCount.Value);
                }
                else
                {
                    writer.WriteNull("componentCount");
                }
            }
            if (Optional.IsDefined(BinaryCount))
            {
                if (BinaryCount != null)
                {
                    writer.WritePropertyName("binaryCount"u8);
                    writer.WriteNumberValue(BinaryCount.Value);
                }
                else
                {
                    writer.WriteNull("binaryCount");
                }
            }
            if (Optional.IsDefined(AnalysisTimeSeconds))
            {
                if (AnalysisTimeSeconds != null)
                {
                    writer.WritePropertyName("analysisTimeSeconds"u8);
                    writer.WriteNumberValue(AnalysisTimeSeconds.Value);
                }
                else
                {
                    writer.WriteNull("analysisTimeSeconds");
                }
            }
            if (Optional.IsDefined(RootFileSystems))
            {
                if (RootFileSystems != null)
                {
                    writer.WritePropertyName("rootFileSystems"u8);
                    writer.WriteNumberValue(RootFileSystems.Value);
                }
                else
                {
                    writer.WriteNull("rootFileSystems");
                }
            }
        }

        FirmwareSummary IJsonModel<FirmwareSummary>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FirmwareSummary>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FirmwareSummary)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeFirmwareSummary(document.RootElement, options);
        }

        internal static FirmwareSummary DeserializeFirmwareSummary(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            long? extractedSize = default;
            long? fileSize = default;
            long? extractedFileCount = default;
            long? componentCount = default;
            long? binaryCount = default;
            long? analysisTimeSeconds = default;
            long? rootFileSystems = default;
            FirmwareAnalysisSummaryType summaryType = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("extractedSize"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        extractedSize = null;
                        continue;
                    }
                    extractedSize = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("fileSize"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        fileSize = null;
                        continue;
                    }
                    fileSize = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("extractedFileCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        extractedFileCount = null;
                        continue;
                    }
                    extractedFileCount = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("componentCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        componentCount = null;
                        continue;
                    }
                    componentCount = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("binaryCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        binaryCount = null;
                        continue;
                    }
                    binaryCount = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("analysisTimeSeconds"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        analysisTimeSeconds = null;
                        continue;
                    }
                    analysisTimeSeconds = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("rootFileSystems"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        rootFileSystems = null;
                        continue;
                    }
                    rootFileSystems = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("summaryType"u8))
                {
                    summaryType = new FirmwareAnalysisSummaryType(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new FirmwareSummary(
                summaryType,
                serializedAdditionalRawData,
                extractedSize,
                fileSize,
                extractedFileCount,
                componentCount,
                binaryCount,
                analysisTimeSeconds,
                rootFileSystems);
        }

        BinaryData IPersistableModel<FirmwareSummary>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FirmwareSummary>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(FirmwareSummary)} does not support writing '{options.Format}' format.");
            }
        }

        FirmwareSummary IPersistableModel<FirmwareSummary>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FirmwareSummary>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeFirmwareSummary(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(FirmwareSummary)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<FirmwareSummary>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
