// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.IotFirmwareDefense.Models
{
    [PersistableModelProxy(typeof(UnknownSummaryResourceProperties))]
    public partial class FirmwareAnalysisSummaryProperties : IUtf8JsonSerializable, IJsonModel<FirmwareAnalysisSummaryProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<FirmwareAnalysisSummaryProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<FirmwareAnalysisSummaryProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FirmwareAnalysisSummaryProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FirmwareAnalysisSummaryProperties)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("summaryType"u8);
            writer.WriteStringValue(SummaryType.ToString());
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        FirmwareAnalysisSummaryProperties IJsonModel<FirmwareAnalysisSummaryProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FirmwareAnalysisSummaryProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FirmwareAnalysisSummaryProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeFirmwareAnalysisSummaryProperties(document.RootElement, options);
        }

        internal static FirmwareAnalysisSummaryProperties DeserializeFirmwareAnalysisSummaryProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            if (element.TryGetProperty("summaryType", out JsonElement discriminator))
            {
                switch (discriminator.GetString())
                {
                    case "BinaryHardening": return BinaryHardeningSummary.DeserializeBinaryHardeningSummary(element, options);
                    case "CryptoCertificate": return CryptoCertificateSummary.DeserializeCryptoCertificateSummary(element, options);
                    case "CryptoKey": return CryptoKeySummary.DeserializeCryptoKeySummary(element, options);
                    case "CVE": return CveSummary.DeserializeCveSummary(element, options);
                    case "Firmware": return FirmwareSummary.DeserializeFirmwareSummary(element, options);
                }
            }
            return UnknownSummaryResourceProperties.DeserializeUnknownSummaryResourceProperties(element, options);
        }

        BinaryData IPersistableModel<FirmwareAnalysisSummaryProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FirmwareAnalysisSummaryProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(FirmwareAnalysisSummaryProperties)} does not support writing '{options.Format}' format.");
            }
        }

        FirmwareAnalysisSummaryProperties IPersistableModel<FirmwareAnalysisSummaryProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FirmwareAnalysisSummaryProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeFirmwareAnalysisSummaryProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(FirmwareAnalysisSummaryProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<FirmwareAnalysisSummaryProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
