// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.IotFirmwareDefense.Models
{
    /// <summary> The status of firmware scan. </summary>
    public readonly partial struct FirmwareAnalysisStatus : IEquatable<FirmwareAnalysisStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FirmwareAnalysisStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FirmwareAnalysisStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PendingValue = "Pending";
        private const string ExtractingValue = "Extracting";
        private const string AnalyzingValue = "Analyzing";
        private const string ReadyValue = "Ready";
        private const string ErrorValue = "Error";

        /// <summary> Pending. </summary>
        public static FirmwareAnalysisStatus Pending { get; } = new FirmwareAnalysisStatus(PendingValue);
        /// <summary> Extracting. </summary>
        public static FirmwareAnalysisStatus Extracting { get; } = new FirmwareAnalysisStatus(ExtractingValue);
        /// <summary> Analyzing. </summary>
        public static FirmwareAnalysisStatus Analyzing { get; } = new FirmwareAnalysisStatus(AnalyzingValue);
        /// <summary> Ready. </summary>
        public static FirmwareAnalysisStatus Ready { get; } = new FirmwareAnalysisStatus(ReadyValue);
        /// <summary> Error. </summary>
        public static FirmwareAnalysisStatus Error { get; } = new FirmwareAnalysisStatus(ErrorValue);
        /// <summary> Determines if two <see cref="FirmwareAnalysisStatus"/> values are the same. </summary>
        public static bool operator ==(FirmwareAnalysisStatus left, FirmwareAnalysisStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FirmwareAnalysisStatus"/> values are not the same. </summary>
        public static bool operator !=(FirmwareAnalysisStatus left, FirmwareAnalysisStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FirmwareAnalysisStatus"/>. </summary>
        public static implicit operator FirmwareAnalysisStatus(string value) => new FirmwareAnalysisStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FirmwareAnalysisStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FirmwareAnalysisStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
