// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.IotFirmwareDefense.Models
{
    /// <summary> CVE analysis result resource. </summary>
    public partial class CveResult : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CveResult"/>. </summary>
        public CveResult()
        {
            Links = new ChangeTrackingList<CveLink>();
        }

        /// <summary> Initializes a new instance of <see cref="CveResult"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="cveId"> ID of the CVE result. </param>
        /// <param name="component"> The SBOM component for the CVE. </param>
        /// <param name="severity"> Severity of the CVE. </param>
        /// <param name="namePropertiesName"> Name of the CVE. </param>
        /// <param name="cvssScore"> A single CVSS score to represent the CVE. If a V3 score is specified, then it will use the V3 score. Otherwise if the V2 score is specified it will be the V2 score. </param>
        /// <param name="cvssVersion"> CVSS version of the CVE. </param>
        /// <param name="cvssV2Score"> CVSS V2 score of the CVE. </param>
        /// <param name="cvssV3Score"> CVSS V3 score of the CVE. </param>
        /// <param name="links"> The list of reference links for the CVE. </param>
        /// <param name="description"> The CVE description. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CveResult(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string cveId, CveComponent component, string severity, string namePropertiesName, string cvssScore, string cvssVersion, string cvssV2Score, string cvssV3Score, IReadOnlyList<CveLink> links, string description, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            CveId = cveId;
            Component = component;
            Severity = severity;
            NamePropertiesName = namePropertiesName;
            CvssScore = cvssScore;
            CvssVersion = cvssVersion;
            CvssV2Score = cvssV2Score;
            CvssV3Score = cvssV3Score;
            Links = links;
            Description = description;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> ID of the CVE result. </summary>
        public string CveId { get; set; }
        /// <summary> The SBOM component for the CVE. </summary>
        public CveComponent Component { get; set; }
        /// <summary> Severity of the CVE. </summary>
        public string Severity { get; set; }
        /// <summary> Name of the CVE. </summary>
        public string NamePropertiesName { get; set; }
        /// <summary> A single CVSS score to represent the CVE. If a V3 score is specified, then it will use the V3 score. Otherwise if the V2 score is specified it will be the V2 score. </summary>
        public string CvssScore { get; set; }
        /// <summary> CVSS version of the CVE. </summary>
        public string CvssVersion { get; set; }
        /// <summary> CVSS V2 score of the CVE. </summary>
        public string CvssV2Score { get; set; }
        /// <summary> CVSS V3 score of the CVE. </summary>
        public string CvssV3Score { get; set; }
        /// <summary> The list of reference links for the CVE. </summary>
        public IReadOnlyList<CveLink> Links { get; }
        /// <summary> The CVE description. </summary>
        public string Description { get; set; }
    }
}
