// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.IotFirmwareDefense.Models
{
    /// <summary> Details of a matching paired key or certificate. </summary>
    public partial class CryptoPairedKey
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CryptoPairedKey"/>. </summary>
        public CryptoPairedKey()
        {
        }

        /// <summary> Initializes a new instance of <see cref="CryptoPairedKey"/>. </summary>
        /// <param name="id"> ID of the paired key or certificate. </param>
        /// <param name="pairedKeyType"> The type indicating whether the paired object is a key or certificate. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CryptoPairedKey(string id, string pairedKeyType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            PairedKeyType = pairedKeyType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> ID of the paired key or certificate. </summary>
        public string Id { get; set; }
        /// <summary> The type indicating whether the paired object is a key or certificate. </summary>
        public string PairedKeyType { get; set; }
    }
}
