// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.IotFirmwareDefense.Models
{
    public partial class CryptoKeySummary : IUtf8JsonSerializable, IJsonModel<CryptoKeySummary>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<CryptoKeySummary>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<CryptoKeySummary>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CryptoKeySummary>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CryptoKeySummary)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (Optional.IsDefined(TotalKeys))
            {
                writer.WritePropertyName("totalKeys"u8);
                writer.WriteNumberValue(TotalKeys.Value);
            }
            if (Optional.IsDefined(PublicKeys))
            {
                writer.WritePropertyName("publicKeys"u8);
                writer.WriteNumberValue(PublicKeys.Value);
            }
            if (Optional.IsDefined(PrivateKeys))
            {
                writer.WritePropertyName("privateKeys"u8);
                writer.WriteNumberValue(PrivateKeys.Value);
            }
            if (Optional.IsDefined(PairedKeys))
            {
                writer.WritePropertyName("pairedKeys"u8);
                writer.WriteNumberValue(PairedKeys.Value);
            }
            if (Optional.IsDefined(ShortKeySize))
            {
                writer.WritePropertyName("shortKeySize"u8);
                writer.WriteNumberValue(ShortKeySize.Value);
            }
        }

        CryptoKeySummary IJsonModel<CryptoKeySummary>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CryptoKeySummary>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CryptoKeySummary)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeCryptoKeySummary(document.RootElement, options);
        }

        internal static CryptoKeySummary DeserializeCryptoKeySummary(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            long? totalKeys = default;
            long? publicKeys = default;
            long? privateKeys = default;
            long? pairedKeys = default;
            long? shortKeySize = default;
            FirmwareAnalysisSummaryType summaryType = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("totalKeys"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    totalKeys = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("publicKeys"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    publicKeys = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("privateKeys"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    privateKeys = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("pairedKeys"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    pairedKeys = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("shortKeySize"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    shortKeySize = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("summaryType"u8))
                {
                    summaryType = new FirmwareAnalysisSummaryType(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new CryptoKeySummary(
                summaryType,
                serializedAdditionalRawData,
                totalKeys,
                publicKeys,
                privateKeys,
                pairedKeys,
                shortKeySize);
        }

        BinaryData IPersistableModel<CryptoKeySummary>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CryptoKeySummary>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(CryptoKeySummary)} does not support writing '{options.Format}' format.");
            }
        }

        CryptoKeySummary IPersistableModel<CryptoKeySummary>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CryptoKeySummary>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeCryptoKeySummary(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(CryptoKeySummary)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<CryptoKeySummary>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
