// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.IotFirmwareDefense.Models
{
    public partial class CryptoCertificateSummary : IUtf8JsonSerializable, IJsonModel<CryptoCertificateSummary>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<CryptoCertificateSummary>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<CryptoCertificateSummary>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CryptoCertificateSummary>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CryptoCertificateSummary)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (Optional.IsDefined(TotalCertificates))
            {
                writer.WritePropertyName("totalCertificates"u8);
                writer.WriteNumberValue(TotalCertificates.Value);
            }
            if (Optional.IsDefined(PairedKeys))
            {
                writer.WritePropertyName("pairedKeys"u8);
                writer.WriteNumberValue(PairedKeys.Value);
            }
            if (Optional.IsDefined(Expired))
            {
                writer.WritePropertyName("expired"u8);
                writer.WriteNumberValue(Expired.Value);
            }
            if (Optional.IsDefined(ExpiringSoon))
            {
                writer.WritePropertyName("expiringSoon"u8);
                writer.WriteNumberValue(ExpiringSoon.Value);
            }
            if (Optional.IsDefined(WeakSignature))
            {
                writer.WritePropertyName("weakSignature"u8);
                writer.WriteNumberValue(WeakSignature.Value);
            }
            if (Optional.IsDefined(SelfSigned))
            {
                writer.WritePropertyName("selfSigned"u8);
                writer.WriteNumberValue(SelfSigned.Value);
            }
            if (Optional.IsDefined(ShortKeySize))
            {
                writer.WritePropertyName("shortKeySize"u8);
                writer.WriteNumberValue(ShortKeySize.Value);
            }
        }

        CryptoCertificateSummary IJsonModel<CryptoCertificateSummary>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CryptoCertificateSummary>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CryptoCertificateSummary)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeCryptoCertificateSummary(document.RootElement, options);
        }

        internal static CryptoCertificateSummary DeserializeCryptoCertificateSummary(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            long? totalCertificates = default;
            long? pairedKeys = default;
            long? expired = default;
            long? expiringSoon = default;
            long? weakSignature = default;
            long? selfSigned = default;
            long? shortKeySize = default;
            FirmwareAnalysisSummaryType summaryType = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("totalCertificates"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    totalCertificates = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("pairedKeys"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    pairedKeys = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("expired"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    expired = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("expiringSoon"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    expiringSoon = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("weakSignature"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    weakSignature = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("selfSigned"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    selfSigned = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("shortKeySize"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    shortKeySize = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("summaryType"u8))
                {
                    summaryType = new FirmwareAnalysisSummaryType(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new CryptoCertificateSummary(
                summaryType,
                serializedAdditionalRawData,
                totalCertificates,
                pairedKeys,
                expired,
                expiringSoon,
                weakSignature,
                selfSigned,
                shortKeySize);
        }

        BinaryData IPersistableModel<CryptoCertificateSummary>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CryptoCertificateSummary>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(CryptoCertificateSummary)} does not support writing '{options.Format}' format.");
            }
        }

        CryptoCertificateSummary IPersistableModel<CryptoCertificateSummary>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CryptoCertificateSummary>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeCryptoCertificateSummary(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(CryptoCertificateSummary)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<CryptoCertificateSummary>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
